/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.tiles.factory;

import fr.iglee42.evolvedmekanism.interfaces.EMInputRecipeCache;
import fr.iglee42.evolvedmekanism.interfaces.IGetEnergySlot;
import fr.iglee42.evolvedmekanism.interfaces.ThreeInputCachedRecipe;
import fr.iglee42.evolvedmekanism.interfaces.TripleItemRecipeLookupHandler;
import fr.iglee42.evolvedmekanism.recipes.AlloyerRecipe;
import fr.iglee42.evolvedmekanism.registries.EMRecipeType;
import fr.iglee42.evolvedmekanism.tiers.EMFactoryTier;
import fr.iglee42.evolvedmekanism.tiles.LimitedInputInventorySlot;
import fr.iglee42.evolvedmekanism.tiles.upgrade.AlloyerUpgradeData;
import java.util.List;
import java.util.Set;
import mekanism.api.IContentsListener;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.tier.FactoryTier;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.factory.TileEntityItemToItemFactory;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityAlloyingFactory
extends TileEntityItemToItemFactory<AlloyerRecipe>
implements TripleItemRecipeLookupHandler<AlloyerRecipe> {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
    private final IInputHandler<@NotNull ItemStack> extraInputHandler;
    private final IInputHandler<@NotNull ItemStack> secondExtraInputHandler;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getSecondaryInput"}, docPlaceholder="secondary input slot")
    LimitedInputInventorySlot extraSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getTertiaryInput"}, docPlaceholder="tertiary input slot")
    LimitedInputInventorySlot secondExtraSlot;

    public TileEntityAlloyingFactory(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        this.extraInputHandler = InputHelper.getInputHandler((IInventorySlot)this.extraSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
        this.secondExtraInputHandler = InputHelper.getInputHandler((IInventorySlot)this.secondExtraSlot, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
        ConfigInfo itemConfig = this.configComponent.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            itemConfig.addSlotInfo(DataType.EXTRA, (ISlotInfo)new InventorySlotInfo(true, true, new IInventorySlot[]{this.extraSlot, this.secondExtraSlot}));
        }
    }

    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        super.addSlots(builder, listener, updateSortingListener);
        int imageWidth = 176 + 38 * (this.tier.ordinal() - EMFactoryTier.OVERCLOCKED.ordinal() + 1) + 9;
        int inventorySize = 180;
        int endInventory = imageWidth / 2 + inventorySize / 2 - 10;
        int extraSlotX = this.tier.ordinal() > FactoryTier.ULTIMATE.ordinal() ? endInventory + 4 : 7;
        int extraSlotY = this.tier.ordinal() > FactoryTier.ULTIMATE.ordinal() ? 143 : 57;
        this.extraSlot = LimitedInputInventorySlot.at((this.tier.ordinal() + 1) * 64, arg_0 -> ((TileEntityAlloyingFactory)this).containsRecipeB(arg_0), this.markAllMonitorsChanged(listener), extraSlotX, extraSlotY);
        builder.addSlot((IInventorySlot)this.extraSlot);
        this.secondExtraSlot = LimitedInputInventorySlot.at((this.tier.ordinal() + 1) * 64, arg_0 -> ((TileEntityAlloyingFactory)this).containsRecipeC(arg_0), this.markAllMonitorsChanged(listener), extraSlotX, extraSlotY - 22);
        builder.addSlot((IInventorySlot)this.secondExtraSlot);
        this.extraSlot.setSlotType(ContainerSlotType.EXTRA);
        this.secondExtraSlot.setSlotType(ContainerSlotType.EXTRA);
    }

    @Nullable
    protected LimitedInputInventorySlot getExtraSlot() {
        return this.extraSlot;
    }

    public LimitedInputInventorySlot getSecondExtraSlot() {
        return this.secondExtraSlot;
    }

    public boolean isValidInputItem(@NotNull ItemStack stack) {
        return this.containsRecipeA(stack);
    }

    protected int getNeededInput(AlloyerRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt((long)recipe.getMainInput().getNeededAmount((Object)inputStack));
    }

    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<AlloyerRecipe> cached, @NotNull ItemStack stack) {
        if (cached != null) {
            AlloyerRecipe cachedRecipe = (AlloyerRecipe)cached.getRecipe();
            return cachedRecipe.getMainInput().testType((Object)stack) && (this.extraSlot.isEmpty() || cachedRecipe.getExtraInput().testType((Object)this.extraSlot.getStack()));
        }
        return false;
    }

    protected AlloyerRecipe findRecipe(int process, @NotNull ItemStack fallbackInput, @NotNull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot) {
        ItemStack extra = this.extraSlot.getStack();
        ItemStack secondExtra = this.secondExtraSlot.getStack();
        ItemStack output = outputSlot.getStack();
        return ((EMInputRecipeCache.IFindRecipes)this.getRecipeType().getInputCache()).findTypeBasedRecipe(this.f_58857_, fallbackInput, extra, secondExtra, recipe -> InventoryUtils.areItemsStackable((ItemStack)recipe.getOutput(fallbackInput, extra, secondExtra), (ItemStack)output));
    }

    @NotNull
    public IMekanismRecipeTypeProvider<AlloyerRecipe, EMInputRecipeCache.TripleItem<AlloyerRecipe>> getRecipeType() {
        return EMRecipeType.ALLOYING;
    }

    @Nullable
    public AlloyerRecipe getRecipe(int cacheIndex) {
        return (AlloyerRecipe)this.findFirstRecipe(this.inputHandlers[cacheIndex], this.extraInputHandler, this.secondExtraInputHandler);
    }

    @NotNull
    public CachedRecipe<AlloyerRecipe> createNewCachedRecipe(@NotNull AlloyerRecipe recipe, int cacheIndex) {
        return ThreeInputCachedRecipe.alloyer(recipe, this.recheckAllRecipeErrors[cacheIndex], (IInputHandler<ItemStack>)this.inputHandlers[cacheIndex], this.extraInputHandler, this.secondExtraInputHandler, (IOutputHandler<ItemStack>)this.outputHandlers[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged(errors, cacheIndex)).setCanHolderFunction(() -> MekanismUtils.canFunction((TileEntityMekanism)this)).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((MachineEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setRequiredTicks(() -> ((TileEntityAlloyingFactory)this).getTicksRequired()).setOnFinish(() -> ((TileEntityAlloyingFactory)this).markForSave()).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        });
    }

    public void parseUpgradeData(@NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof AlloyerUpgradeData) {
            AlloyerUpgradeData data = (AlloyerUpgradeData)upgradeData;
            super.parseUpgradeData(upgradeData);
            this.extraSlot.deserializeNBT(data.extraSlot.serializeNBT());
            this.secondExtraSlot.deserializeNBT(data.secondaryExtraSlot.serializeNBT());
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
        }
    }

    @NotNull
    public AlloyerUpgradeData getUpgradeData() {
        return new AlloyerUpgradeData(this.redstone, this.getControlType(), (IEnergyContainer)this.getEnergyContainer(), this.progress, ((IGetEnergySlot)((Object)this)).getEnergySlot(), this.extraSlot, this.secondExtraSlot, this.inputSlots, this.outputSlots, this.isSorting(), this.getComponents());
    }
}

